/*
 * Decompiled with CFR 0.152.
 */
package com.github.games647.scoreboardstats;

import com.avaje.ebean.EbeanServer;
import com.avaje.ebean.EbeanServerFactory;
import com.avaje.ebean.config.DataSourceConfig;
import com.avaje.ebean.config.ServerConfig;
import com.avaje.ebeaninternal.api.SpiEbeanServer;
import com.avaje.ebeaninternal.server.ddl.DdlGenerator;
import com.avaje.ebeaninternal.server.lib.sql.TransactionIsolation;
import com.github.games647.scoreboardstats.RefreshTask;
import com.github.games647.scoreboardstats.Settings;
import com.github.games647.scoreboardstats.Updater;
import com.github.games647.scoreboardstats.commands.DisableCommand;
import com.github.games647.scoreboardstats.commands.ReloadCommand;
import com.github.games647.scoreboardstats.commands.SidebarCommand;
import com.github.games647.scoreboardstats.listener.EntityListener;
import com.github.games647.scoreboardstats.listener.PlayerListener;
import com.github.games647.scoreboardstats.listener.PluginListener;
import com.github.games647.scoreboardstats.pvpstats.Database;
import com.github.games647.scoreboardstats.pvpstats.PlayerStats;
import com.github.games647.scoreboardstats.scoreboard.ReflectionUtil;
import com.github.games647.scoreboardstats.scoreboard.SbManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.persistence.PersistenceException;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.fusesource.jansi.Ansi;

public final class ScoreboardStats
extends JavaPlugin {
    private final Set<String> hidelist = new HashSet<String>(10);
    private static ScoreboardStats instance;
    private int taskid;

    public static ScoreboardStats getInstance() {
        return instance;
    }

    public ScoreboardStats() {
        instance = this;
    }

    public Set<String> getHidelist() {
        return this.hidelist;
    }

    public void onEnable() {
        super.onEnable();
        this.saveDefaultConfig();
        Settings.loadConfig();
        if (Settings.isUpdateInfo()) {
            new Updater((Plugin)this, "scoreboardstats", this.getFile(), Updater.UpdateType.DEFAULT, true);
        }
        this.setupDatabase();
        PluginListener.init();
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new EntityListener(), (Plugin)this);
        this.getCommand("sb:reload").setExecutor((CommandExecutor)new ReloadCommand());
        this.getCommand("sb:toggle").setExecutor((CommandExecutor)new DisableCommand());
        this.getCommand("sidebar").setExecutor((CommandExecutor)new SidebarCommand());
        SbManager.regAll();
        this.taskid = this.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this, (Runnable)new RefreshTask(), 60L, (long)Settings.getIntervall() * 20L - 10L);
    }

    public List<Class<?>> getDatabaseClasses() {
        ArrayList arrayList = new ArrayList(1);
        arrayList.add(PlayerStats.class);
        return arrayList;
    }

    public void onLoad() {
        super.onLoad();
        ReflectionUtil.initReflections();
    }

    public void onReload() {
        int n = Settings.getIntervall();
        int n2 = Settings.getItemsLenght();
        boolean bl = Settings.isPvpStats();
        Settings.loadConfig();
        if (n != Settings.getIntervall()) {
            this.getServer().getScheduler().cancelTask(this.taskid);
            this.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this, (Runnable)new RefreshTask(), 60L, (long)Settings.getIntervall() * 20L - 10L);
        }
        if (n2 != Settings.getItemsLenght()) {
            SbManager.unregisterAll();
        }
        if (bl != Settings.isPvpStats()) {
            instance.setupDatabase();
            SbManager.regAll();
        }
    }

    public void onDisable() {
        super.onDisable();
        this.getServer().getScheduler().cancelTasks((Plugin)this);
        Database.saveAll();
        SbManager.unregisterAll();
        HandlerList.unregisterAll((Plugin)this);
    }

    private void setupDatabase() {
        if (Settings.isPvpStats()) {
            ServerConfig serverConfig = new ServerConfig();
            serverConfig.setRegister(false);
            serverConfig.setClasses(this.getDatabaseClasses());
            serverConfig.setName(this.getName());
            DataSourceConfig dataSourceConfig = this.getSqlConfig(serverConfig);
            dataSourceConfig.setUrl(this.replaceUrlString(dataSourceConfig.getUrl()));
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClassLoader());
            EbeanServer ebeanServer = EbeanServerFactory.create((ServerConfig)serverConfig);
            Thread.currentThread().setContextClassLoader(classLoader);
            try {
                ebeanServer.find(PlayerStats.class).findRowCount();
            }
            catch (PersistenceException persistenceException) {
                this.getLogger().log(Level.INFO, "{0}Can't find an existing Database, so creating a new one" + Ansi.ansi().fg(Ansi.Color.DEFAULT), Ansi.ansi().fg(Ansi.Color.YELLOW));
                DdlGenerator ddlGenerator = ((SpiEbeanServer)ebeanServer).getDdlGenerator();
                ddlGenerator.runScript(false, ddlGenerator.generateCreateDdl());
            }
            Database.setDatabase(ebeanServer);
        }
    }

    private String replaceUrlString(String string) {
        Pattern pattern = Pattern.compile("\\\\");
        return string.replace("{DIR}", pattern.matcher(this.getDataFolder().getPath()).replaceAll("/") + '/').replace("{NAME}", this.getName());
    }

    private DataSourceConfig getSqlConfig(ServerConfig serverConfig) {
        DataSourceConfig dataSourceConfig;
        YamlConfiguration yamlConfiguration;
        File file = new File(this.getDataFolder(), "sql.yml");
        if (file.exists()) {
            yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
            dataSourceConfig = new DataSourceConfig();
            dataSourceConfig.setUsername(yamlConfiguration.getString("SQL-Settings.Username"));
            dataSourceConfig.setPassword(yamlConfiguration.getString("SQL-Settings.Password"));
            dataSourceConfig.setIsolationLevel(TransactionIsolation.getLevel((String)yamlConfiguration.getString("SQL-Settings.Isolation")));
            dataSourceConfig.setDriver(yamlConfiguration.getString("SQL-Settings.Driver"));
            dataSourceConfig.setUrl(yamlConfiguration.getString("SQL-Settings.Url"));
            serverConfig.setDataSourceConfig(dataSourceConfig);
        } else {
            this.saveResource("sql.yml", false);
            this.getServer().configureDbConfig(serverConfig);
            dataSourceConfig = serverConfig.getDataSourceConfig();
            yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
            yamlConfiguration.set("SQL-Settings.Username", (Object)dataSourceConfig.getUsername());
            yamlConfiguration.set("SQL-Settings.Password", (Object)dataSourceConfig.getPassword());
            yamlConfiguration.set("SQL-Settings.Isolation", (Object)TransactionIsolation.getLevelDescription((int)dataSourceConfig.getIsolationLevel()));
            yamlConfiguration.set("SQL-Settings.Driver", (Object)dataSourceConfig.getDriver());
            yamlConfiguration.set("SQL-Settings.Url", (Object)dataSourceConfig.getUrl());
            try {
                yamlConfiguration.save(file);
            }
            catch (IOException iOException) {
                this.getLogger().log(Level.WARNING, "{0}Error while trying to save the sql.yml" + Ansi.ansi().fg(Ansi.Color.DEFAULT), Ansi.ansi().fg(Ansi.Color.RED));
                this.getLogger().throwing(((Object)((Object)this)).getClass().getName(), "getSqlConfig", iOException);
            }
        }
        dataSourceConfig.setMinConnections(yamlConfiguration.getInt("SQL-Settings.MinConnections"));
        dataSourceConfig.setMaxConnections(yamlConfiguration.getInt("SQL-Settings.MaxConnections"));
        dataSourceConfig.setWaitTimeoutMillis(yamlConfiguration.getInt("SQL-Settings.Timeout"));
        return dataSourceConfig;
    }
}

