/*
 * Decompiled with CFR 0.152.
 */
package com.github.games647.scoreboardstats;

import com.github.games647.scoreboardstats.ScoreboardStats;
import com.github.games647.scoreboardstats.scoreboard.SbManager;
import com.github.games647.scoreboardstats.scoreboard.VariableReplacer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.fusesource.jansi.Ansi;

public final class Settings {
    private static final ScoreboardStats PLUGIN = ScoreboardStats.getInstance();
    private static boolean pvpStats;
    private static boolean tempScoreboard;
    private static boolean hideVanished;
    private static boolean sound;
    private static boolean updateInfo;
    private static boolean packetsystem;
    private static String title;
    private static String tempTitle;
    private static String tempColor;
    private static String topType;
    private static int intervall;
    private static int topitems;
    private static int tempShow;
    private static int tempDisapper;
    private static final Map<String, String> ITEMS;
    private static List<String> disabledWorlds;

    public static void loadConfig() {
        PLUGIN.reloadConfig();
        FileConfiguration fileConfiguration = PLUGIN.getConfig();
        Settings.loaditems(fileConfiguration.getConfigurationSection("Scoreboard.Items"));
        hideVanished = fileConfiguration.getBoolean("hide-vanished");
        sound = fileConfiguration.getBoolean("enable-sound");
        pvpStats = fileConfiguration.getBoolean("enable-pvpstats");
        updateInfo = fileConfiguration.getBoolean("enable-auto-update");
        packetsystem = fileConfiguration.getBoolean("use-packet-system");
        disabledWorlds = fileConfiguration.getStringList("disabled-worlds");
        intervall = fileConfiguration.getInt("Scoreboard.Update-delay");
        title = ChatColor.translateAlternateColorCodes((char)'&', (String)Settings.checkLength(Settings.replaceSpecialCharacters(fileConfiguration.getString("Scoreboard.Title")), 32));
        if (fileConfiguration.getBoolean("Temp-Scoreboard-enabled") && pvpStats) {
            tempScoreboard = true;
            topitems = Settings.checkItems(fileConfiguration.getInt("Temp-Scoreboard.Items"));
            tempShow = fileConfiguration.getInt("Temp-Scoreboard.Intervall-show");
            tempDisapper = fileConfiguration.getInt("Temp-Scoreboard.Intervall-disappear");
            topType = fileConfiguration.getString("Temp-Scoreboard.Type");
            tempColor = ChatColor.translateAlternateColorCodes((char)'&', (String)fileConfiguration.getString("Temp-Scoreboard.Color"));
            tempTitle = ChatColor.translateAlternateColorCodes((char)'&', (String)Settings.checkLength(Settings.replaceSpecialCharacters(fileConfiguration.getString("Temp-Scoreboard.Title")), 32));
        }
    }

    public static void sendUpdate(Player player, boolean bl) {
        Objective objective = player.getScoreboard().getObjective(DisplaySlot.SIDEBAR);
        if (!player.hasPermission("scoreboardstats.use") || objective == null || !objective.getName().equals("ScoreboardStats") || PLUGIN.getHidelist().contains(player.getName())) {
            return;
        }
        for (Map.Entry<String, String> entry : ITEMS.entrySet()) {
            SbManager.sendScore(objective, entry.getKey(), VariableReplacer.getReplacedInt(entry.getValue(), player), bl);
        }
    }

    private static String checkLength(String string, int n) {
        if (string.length() > n) {
            String string2 = string.substring(0, n);
            Bukkit.getLogger().log(Level.WARNING, Ansi.ansi().fg(Ansi.Color.RED) + "[ScoreboardStats] " + "{0}" + Ansi.ansi().fg(Ansi.Color.DEFAULT), String.format("%s was longer than the limit of %s characters. This Plugin will cut automatically to the right size.", string2, n));
            return string2;
        }
        return string;
    }

    private static int checkItems(int n) {
        if (n >= 16) {
            Bukkit.getLogger().log(Level.WARNING, "{0}[ScoreboardStats] One Scoreboard can't have more than 15 items" + Ansi.ansi().fg(Ansi.Color.DEFAULT), Ansi.ansi().fg(Ansi.Color.RED));
            return 15;
        }
        return n;
    }

    private static void loaditems(ConfigurationSection configurationSection) {
        Set set = configurationSection.getKeys(false);
        if (!ITEMS.isEmpty()) {
            ITEMS.clear();
        }
        for (String string : set) {
            if (ITEMS.size() >= 16) {
                Bukkit.getLogger().log(Level.WARNING, "{0}[ScoreboardStats] One Scoreboard can't have more than 15 items" + Ansi.ansi().fg(Ansi.Color.DEFAULT), Ansi.ansi().fg(Ansi.Color.RED));
                break;
            }
            ITEMS.put(ChatColor.translateAlternateColorCodes((char)'\u00a7', (String)Settings.checkLength(Settings.replaceSpecialCharacters(string), 16)), configurationSection.getString(string));
        }
    }

    private static String replaceSpecialCharacters(String string) {
        return string.replace("[<3]", "\u2764").replace("[check]", "\u2714").replace("[<]", "\u25c4").replace("[>]", "\u25ba").replace("[star]", "\u2605").replace("[round_star]", "\u272a").replace("[stars]", "\u2042").replace("[crown]", "\u265b").replace("[chess]", "\u265c").replace("[top]", "\u2580").replace("[button]", "\u2584").replace("[side]", "\u258c").replace("[mid]", "\u25ac").replace("[1]", "\u2582").replace("[2]", "\u2583").replace("[3]", "\u2584").replace("[4]", "\u2585").replace("[5]", "\u2586").replace("[6]", "\u2587").replace("[7]", "\u2588").replace("[8]", "\u2593").replace("[9]", "\u2592").replace("[10]", "\u2591").replace("[right_up]", "\u22f0").replace("[left_up]", "\u22f1").replace("[PHONE]", "\u2706").replace("[PLANE]", "\u2708").replace("[FLOWER]", "\u273f").replace("[MAIL]", "\u2709").replace("[HAND]", "\u270c").replace("[WRITE]", "\u270d").replace("[PENCIL]", "\u270e").replace("[X]", "\u2716").replace("[T_STAR]", "\u2730").replace("[ARROW]", "\u27bd").replace("[ARROW1]", "\u27a8").replace("[ARROW2]", "\u27a4").replace("[ARROW3]", "\u279c").replace("[ARROW4]", "\u27a8").replace("[ONE]", "\u2776").replace("[TWO]", "\u2777").replace("[THREE]", "\u2778").replace("[FOUR]", "\u2779").replace("[FIVE]", "\u277a").replace("[SIX]", "\u277b").replace("[SEVEN]", "\u277c").replace("[EIGHT]", "\u277d").replace("[NINE]", "\u277e").replace("[TEN]", "\u277f");
    }

    public static boolean isPvpStats() {
        return pvpStats;
    }

    public static boolean isTempScoreboard() {
        return tempScoreboard;
    }

    public static boolean isHideVanished() {
        return hideVanished;
    }

    public static boolean isSound() {
        return sound;
    }

    public static boolean isUpdateInfo() {
        return updateInfo;
    }

    public static boolean isPacketsystem() {
        return packetsystem;
    }

    public static String getTitle() {
        return title;
    }

    public static String getTempTitle() {
        return tempTitle;
    }

    public static String getTempColor() {
        return tempColor;
    }

    public static String getTopType() {
        return topType;
    }

    public static int getIntervall() {
        return intervall;
    }

    public static int getTopitems() {
        return topitems;
    }

    public static int getTempShow() {
        return tempShow;
    }

    public static int getTempDisapper() {
        return tempDisapper;
    }

    public static int getItemsLenght() {
        return ITEMS.size();
    }

    public static boolean isDisabledWorld(String string) {
        return disabledWorlds.contains(string);
    }

    public String toString() {
        return "SettingsHandler{pvpStats=" + pvpStats + ", tempScoreboard=" + tempScoreboard + ", hideVanished=" + hideVanished + ", sound=" + sound + ", title=" + title + ", tempTitle=" + tempTitle + ", tempColor=" + tempColor + ", topType=" + topType + ", intervall=" + intervall + ", topitems=" + topitems + ", tempShow=" + tempShow + ", tempDisapper=" + tempDisapper + ", items=" + ITEMS + ", disabledWorlds=" + disabledWorlds + '}';
    }

    static {
        ITEMS = new HashMap<String, String>(14);
    }
}

