/*
 * Decompiled with CFR 0.152.
 */
package com.github.games647.scoreboardstats;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class Updater {
    private Plugin plugin;
    private UpdateType type;
    private String versionTitle;
    private String versionLink;
    private long totalSize;
    private int sizeLine;
    private int multiplier;
    private boolean announce;
    private URL url;
    private File file;
    private Thread thread;
    private static final String DBOUrl = "http://dev.bukkit.org/bukkit-plugins/";
    private String[] noUpdateTag = new String[]{"-DEV", "-PRE", "-SNAPSHOT"};
    private static final int BYTE_SIZE = 1024;
    private String updateFolder = YamlConfiguration.loadConfiguration((File)new File("bukkit.yml")).getString("settings.update-folder");
    private UpdateResult result = UpdateResult.SUCCESS;
    private static final String TITLE = "title";
    private static final String LINK = "link";
    private static final String ITEM = "item";

    public Updater(Plugin plugin, String string, File file, UpdateType updateType, boolean bl) {
        this.plugin = plugin;
        this.type = updateType;
        this.announce = bl;
        this.file = file;
        try {
            this.url = new URL(DBOUrl + string + "/files.rss");
        }
        catch (MalformedURLException malformedURLException) {
            plugin.getLogger().warning("The author of this plugin (" + (String)plugin.getDescription().getAuthors().get(0) + ") has misconfigured their Auto Update system");
            plugin.getLogger().warning("The project slug given ('" + string + "') is invalid. Please nag the author about this.");
            this.result = UpdateResult.FAIL_BADSLUG;
        }
        this.thread = new Thread(new UpdateRunnable());
        this.thread.start();
    }

    public UpdateResult getResult() {
        this.waitForThread();
        return this.result;
    }

    public long getFileSize() {
        this.waitForThread();
        return this.totalSize;
    }

    public String getLatestVersionString() {
        this.waitForThread();
        return this.versionTitle;
    }

    public void waitForThread() {
        if (this.thread.isAlive()) {
            try {
                this.thread.join();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveFile(File file, String string, String string2) {
        if (!file.exists()) {
            file.mkdir();
        }
        BufferedInputStream bufferedInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            int n;
            URL uRL = new URL(string2);
            int n2 = uRL.openConnection().getContentLength();
            bufferedInputStream = new BufferedInputStream(uRL.openStream());
            fileOutputStream = new FileOutputStream(file.getAbsolutePath() + "/" + string);
            byte[] byArray = new byte[1024];
            if (this.announce) {
                this.plugin.getLogger().info("About to download a new update: " + this.versionTitle);
            }
            long l = 0L;
            while ((n = bufferedInputStream.read(byArray, 0, 1024)) != -1) {
                fileOutputStream.write(byArray, 0, n);
                int n3 = (int)((l += (long)n) * 100L / (long)n2);
                if (!(this.announce & n3 % 10 == 0)) continue;
                this.plugin.getLogger().info("Downloading update: " + n3 + "% of " + n2 + " bytes.");
            }
            for (File file2 : new File("plugins/" + this.updateFolder).listFiles()) {
                if (!file2.getName().endsWith(".zip")) continue;
                file2.delete();
            }
            File file3 = new File(file.getAbsolutePath() + "/" + string);
            if (file3.getName().endsWith(".zip")) {
                this.unzip(file3.getCanonicalPath());
            }
            if (this.announce) {
                this.plugin.getLogger().info("Finished updating.");
            }
        }
        catch (Exception exception) {
            this.plugin.getLogger().warning("The auto-updater tried to download a new update, but was unsuccessful.");
            this.result = UpdateResult.FAIL_DOWNLOAD;
        }
        finally {
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private void unzip(String string) {
        try {
            File[] fileArray;
            Object object;
            File file = new File(string);
            String string2 = string.substring(0, string.length() - 4);
            ZipFile zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                int n;
                File[] fileArray2 = enumeration.nextElement();
                File file2 = new File(string2, fileArray2.getName());
                file2.getParentFile().mkdirs();
                if (fileArray2.isDirectory()) continue;
                BufferedInputStream bufferedInputStream = new BufferedInputStream(zipFile.getInputStream((ZipEntry)fileArray2));
                object = new byte[1024];
                fileArray = new FileOutputStream(file2);
                File[] fileArray3 = new BufferedOutputStream((OutputStream)fileArray, 1024);
                while ((n = bufferedInputStream.read((byte[])object, 0, 1024)) != -1) {
                    fileArray3.write((byte[])object, 0, n);
                }
                fileArray3.flush();
                fileArray3.close();
                bufferedInputStream.close();
                String string3 = file2.getName();
                if (string3.endsWith(".jar") && this.pluginFile(string3)) {
                    file2.renameTo(new File("plugins/" + this.updateFolder + "/" + string3));
                }
                fileArray2 = null;
                file2 = null;
            }
            enumeration = null;
            zipFile.close();
            zipFile = null;
            for (File file3 : new File(string2).listFiles()) {
                if (file3.isDirectory() && this.pluginFile(file3.getName())) {
                    object = new File("plugins/" + file3.getName());
                    fileArray = ((File)object).listFiles();
                    for (File file4 : file3.listFiles()) {
                        boolean bl = false;
                        for (File file5 : fileArray) {
                            if (!file5.getName().equals(file4.getName())) continue;
                            bl = true;
                            break;
                        }
                        if (!bl) {
                            file4.renameTo(new File(((File)object).getCanonicalFile() + "/" + file4.getName()));
                            continue;
                        }
                        file4.delete();
                    }
                }
                file3.delete();
            }
            new File(string2).delete();
            file.delete();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.plugin.getLogger().warning("The auto-updater tried to unzip a new update file, but was unsuccessful.");
            this.result = UpdateResult.FAIL_DOWNLOAD;
        }
        new File(string).delete();
    }

    public boolean pluginFile(String string) {
        for (File file : new File("plugins").listFiles()) {
            if (!file.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    private String getFile(String string) {
        String string2 = null;
        try {
            String string3;
            URL uRL = new URL(string);
            URLConnection uRLConnection = uRL.openConnection();
            InputStreamReader inputStreamReader = new InputStreamReader(uRLConnection.getInputStream());
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            int n = 0;
            while ((string3 = bufferedReader.readLine()) != null) {
                ++n;
                if (string3.contains("<li class=\"user-action user-action-download\">")) {
                    string2 = string3.split("<a href=\"")[1].split("\">Download</a>")[0];
                    continue;
                }
                if (string3.contains("<dt>Size</dt>")) {
                    this.sizeLine = n + 1;
                    continue;
                }
                if (n != this.sizeLine) continue;
                String string4 = string3.replaceAll("<dd>", "").replaceAll("</dd>", "");
                this.multiplier = string4.contains("MiB") ? 0x100000 : 1024;
                string4 = string4.replace(" KiB", "").replace(" MiB", "");
                this.totalSize = (long)(Double.parseDouble(string4) * (double)this.multiplier);
            }
            uRLConnection = null;
            inputStreamReader = null;
            bufferedReader.close();
            bufferedReader = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.plugin.getLogger().warning("The auto-updater tried to contact dev.bukkit.org, but was unsuccessful.");
            this.result = UpdateResult.FAIL_DBO;
            return null;
        }
        return string2;
    }

    private boolean versionCheck(String string) {
        if (this.type != UpdateType.NO_VERSION_CHECK) {
            String string2 = this.plugin.getDescription().getVersion();
            if (string.split(" v").length == 2) {
                String string3 = string.split(" v")[1].split(" ")[0];
                int n = -1;
                int n2 = 0;
                try {
                    n = this.calVer(string3);
                    n2 = this.calVer(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    n = -1;
                }
                if (this.hasTag(string2) || string2.equalsIgnoreCase(string3) || n2 >= n) {
                    this.result = UpdateResult.NO_UPDATE;
                    return false;
                }
            } else {
                this.plugin.getLogger().warning("The author of this plugin (" + (String)this.plugin.getDescription().getAuthors().get(0) + ") has misconfigured their Auto Update system");
                this.plugin.getLogger().warning("Files uploaded to BukkitDev should contain the version number, seperated from the name by a 'v', such as PluginName v1.0");
                this.plugin.getLogger().warning("Please notify the author of this error.");
                this.result = UpdateResult.FAIL_NOVERSION;
                return false;
            }
        }
        return true;
    }

    private Integer calVer(String string) throws NumberFormatException {
        if (string.contains(".")) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < string.length(); ++i) {
                Character c = Character.valueOf(string.charAt(i));
                if (!Character.isLetterOrDigit(c.charValue())) continue;
                stringBuilder.append(c);
            }
            return Integer.parseInt(stringBuilder.toString());
        }
        return Integer.parseInt(string);
    }

    private boolean hasTag(String string) {
        for (String string2 : this.noUpdateTag) {
            if (!string.contains(string2)) continue;
            return true;
        }
        return false;
    }

    private boolean readFeed() {
        try {
            String string = "";
            String string2 = "";
            XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
            InputStream inputStream = this.read();
            if (inputStream != null) {
                XMLEventReader xMLEventReader = xMLInputFactory.createXMLEventReader(inputStream);
                while (xMLEventReader.hasNext()) {
                    XMLEvent xMLEvent = xMLEventReader.nextEvent();
                    if (xMLEvent.isStartElement()) {
                        if (xMLEvent.asStartElement().getName().getLocalPart().equals(TITLE)) {
                            xMLEvent = xMLEventReader.nextEvent();
                            string = xMLEvent.asCharacters().getData();
                            continue;
                        }
                        if (!xMLEvent.asStartElement().getName().getLocalPart().equals(LINK)) continue;
                        xMLEvent = xMLEventReader.nextEvent();
                        string2 = xMLEvent.asCharacters().getData();
                        continue;
                    }
                    if (!xMLEvent.isEndElement() || !xMLEvent.asEndElement().getName().getLocalPart().equals(ITEM)) continue;
                    this.versionTitle = string;
                    this.versionLink = string2;
                    break;
                }
                return true;
            }
            return false;
        }
        catch (XMLStreamException xMLStreamException) {
            this.plugin.getLogger().warning("Could not reach dev.bukkit.org for update checking. Is it offline?");
            return false;
        }
    }

    private InputStream read() {
        try {
            return this.url.openStream();
        }
        catch (IOException iOException) {
            this.plugin.getLogger().warning("Could not reach BukkitDev file stream for update checking. Is dev.bukkit.org offline?");
            return null;
        }
    }

    private class UpdateRunnable
    implements Runnable {
        private UpdateRunnable() {
        }

        @Override
        public void run() {
            if (Updater.this.url != null && Updater.this.readFeed() && Updater.this.versionCheck(Updater.this.versionTitle)) {
                String string = Updater.this.getFile(Updater.this.versionLink);
                if (string != null && Updater.this.type != UpdateType.NO_DOWNLOAD) {
                    String string2 = Updater.this.file.getName();
                    if (string.endsWith(".zip")) {
                        String[] stringArray = string.split("/");
                        string2 = stringArray[stringArray.length - 1];
                    }
                    Updater.this.saveFile(new File("plugins/" + Updater.this.updateFolder), string2, string);
                } else {
                    Updater.this.result = UpdateResult.UPDATE_AVAILABLE;
                }
            }
        }
    }

    public static enum UpdateType {
        DEFAULT,
        NO_VERSION_CHECK,
        NO_DOWNLOAD;

    }

    public static enum UpdateResult {
        SUCCESS,
        NO_UPDATE,
        FAIL_DOWNLOAD,
        FAIL_DBO,
        FAIL_NOVERSION,
        FAIL_BADSLUG,
        UPDATE_AVAILABLE;

    }
}

