/*
 * Decompiled with CFR 0.152.
 */
package com.github.games647.scoreboardstats.listener;

import com.github.games647.scoreboardstats.ScoreboardStats;
import com.github.games647.scoreboardstats.Settings;
import com.github.games647.scoreboardstats.pvpstats.Database;
import com.github.games647.scoreboardstats.pvpstats.PlayerCache;
import com.github.games647.scoreboardstats.pvpstats.SaveTask;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scoreboard.DisplaySlot;

public final class PlayerListener
implements Listener {
    @EventHandler
    public static void onDeath(PlayerDeathEvent playerDeathEvent) {
        Player player = playerDeathEvent.getEntity();
        Player player2 = player.getKiller();
        if (!Settings.isPvpStats() || Settings.isDisabledWorld(player.getWorld().getName())) {
            return;
        }
        PlayerCache playerCache = Database.getCache(player.getName());
        if (playerCache != null) {
            playerCache.onDeath();
        }
        if (player2 != null && player2.isOnline()) {
            PlayerCache playerCache2 = Database.getCache(player2.getName());
            if (playerCache2 != null) {
                playerCache2.onKill();
            }
            if (Settings.isSound()) {
                player2.playSound(player2.getLocation(), Sound.ORB_PICKUP, 50.0f, 1.0f);
            }
        }
    }

    @EventHandler
    public static void onJoin(PlayerJoinEvent playerJoinEvent) {
        final Player player = playerJoinEvent.getPlayer();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)ScoreboardStats.getInstance(), new Runnable(){

            @Override
            public void run() {
                if (Settings.isPvpStats()) {
                    Database.loadAccount(player.getName());
                }
            }
        });
    }

    @EventHandler(ignoreCancelled=true)
    public static void onChange(PlayerChangedWorldEvent playerChangedWorldEvent) {
        Player player = playerChangedWorldEvent.getPlayer();
        if (Settings.isDisabledWorld(player.getWorld().getName())) {
            player.getScoreboard().clearSlot(DisplaySlot.SIDEBAR);
        }
    }

    @EventHandler
    public static void onKick(PlayerKickEvent playerKickEvent) {
        if (Settings.isPvpStats()) {
            Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)ScoreboardStats.getInstance(), (Runnable)new SaveTask(playerKickEvent.getPlayer()), 3600L);
        }
    }

    @EventHandler
    public static void onQuit(PlayerQuitEvent playerQuitEvent) {
        if (Settings.isPvpStats()) {
            Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)ScoreboardStats.getInstance(), (Runnable)new SaveTask(playerQuitEvent.getPlayer()), 3600L);
        }
    }
}

