/*
 * Decompiled with CFR 0.152.
 */
package com.github.games647.scoreboardstats.pvpstats;

import com.avaje.ebean.EbeanServer;
import com.github.games647.scoreboardstats.Settings;
import com.github.games647.scoreboardstats.pvpstats.PlayerCache;
import com.github.games647.scoreboardstats.pvpstats.PlayerStats;
import java.util.HashMap;
import java.util.Map;

public final class Database {
    private static EbeanServer databaseInstance;
    private static final Map<String, PlayerCache> CACHE;

    private Database() {
    }

    public static void setDatabase(EbeanServer ebeanServer) {
        databaseInstance = ebeanServer;
    }

    public static PlayerCache getCache(String string) {
        if (!CACHE.containsKey(string)) {
            Database.loadAccount(string);
        }
        return CACHE.get(string);
    }

    public static void loadAccount(String string) {
        if (CACHE.containsKey(string)) {
            return;
        }
        PlayerStats playerStats = (PlayerStats)databaseInstance.find(PlayerStats.class).where().eq("playername", (Object)string).findUnique();
        CACHE.put(string, playerStats == null ? new PlayerCache() : new PlayerCache(playerStats.getKills(), playerStats.getMobkills(), playerStats.getDeaths(), playerStats.getKillstreak()));
    }

    public static int getKdr(String string) {
        PlayerCache playerCache = Database.getCache(string);
        return playerCache == null ? 0 : (playerCache.getDeaths() == 0 ? playerCache.getKills() : Math.round((float)playerCache.getKills() / (float)playerCache.getDeaths()));
    }

    public static void saveAccount(String string, boolean bl) {
        if (!Settings.isPvpStats()) {
            return;
        }
        PlayerCache playerCache = CACHE.get(string);
        if (playerCache == null) {
            return;
        }
        if (bl) {
            CACHE.remove(string);
        }
        if (playerCache.getKills() == 0 && playerCache.getDeaths() == 0 && playerCache.getMob() == 0) {
            return;
        }
        PlayerStats playerStats = (PlayerStats)databaseInstance.find(PlayerStats.class).where().eq("playername", (Object)string).findUnique();
        if (playerStats == null) {
            playerStats = new PlayerStats();
            playerStats.setPlayername(string);
        }
        if (playerStats.getDeaths() == playerCache.getDeaths() && playerStats.getKills() == playerCache.getKills() && playerStats.getMobkills() == playerCache.getMob() && playerStats.getKillstreak() == playerCache.getStreak()) {
            return;
        }
        playerStats.setDeaths(playerCache.getDeaths());
        playerStats.setKills(playerCache.getKills());
        playerStats.setMobkills(playerCache.getMob());
        playerStats.setKillstreak(playerCache.getStreak());
        databaseInstance.save((Object)playerStats);
    }

    public static void saveAll() {
        if (!Settings.isPvpStats()) {
            return;
        }
        for (String string : CACHE.keySet()) {
            Database.saveAccount(string, false);
        }
        CACHE.clear();
    }

    public static Map<String, Integer> getTop() {
        String string = Settings.getTopType();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>(Settings.getTopitems());
        if ("%killstreak%".equals(string)) {
            for (PlayerStats playerStats : databaseInstance.find(PlayerStats.class).orderBy("killstreak desc").setMaxRows(Settings.getTopitems()).findList()) {
                hashMap.put(playerStats.getPlayername(), playerStats.getKillstreak());
            }
        } else if ("%mob%".equals(string)) {
            for (PlayerStats playerStats : databaseInstance.find(PlayerStats.class).orderBy("mobkills desc").setMaxRows(Settings.getTopitems()).findList()) {
                hashMap.put(playerStats.getPlayername(), playerStats.getMobkills());
            }
        } else {
            for (PlayerStats playerStats : databaseInstance.find(PlayerStats.class).orderBy("kills desc").setMaxRows(Settings.getTopitems()).findList()) {
                hashMap.put(playerStats.getPlayername(), playerStats.getKills());
            }
        }
        return hashMap;
    }

    static {
        CACHE = new HashMap<String, PlayerCache>(10);
    }
}

