/*
 * Decompiled with CFR 0.152.
 */
package com.github.games647.scoreboardstats.scoreboard;

import com.github.games647.scoreboardstats.ScoreboardStats;
import com.github.games647.scoreboardstats.compatibility.ICraftPlayerPing;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.fusesource.jansi.Ansi;

public final class ReflectionUtil {
    private static final ScoreboardStats PLUGIN = ScoreboardStats.getInstance();
    private static String bukkitVersion;
    private static boolean skip;
    private static boolean disabled;
    private static Class<?> classCraft;
    private static Method getHandle;
    private static Field ping;
    private static ICraftPlayerPing compabilityClass;

    private static void setupClass() {
        try {
            compabilityClass = (ICraftPlayerPing)Class.forName("com.github.games647.scoreboardstats.compatibility.Craft" + bukkitVersion).newInstance();
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            PLUGIN.getLogger().log(Level.FINE, "The class couldn't be found", classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            PLUGIN.getLogger().log(Level.FINE, "Error while instantiation", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            PLUGIN.getLogger().log(Level.FINE, "Error while accesing", illegalAccessException);
        }
        skip = true;
        PLUGIN.getLogger().log(Level.INFO, "{0}The Plugin isn''t compatible with your craftbukkit version. It will now try to use Reflections{1}", new Object[]{Ansi.ansi().fg(Ansi.Color.YELLOW), Ansi.ansi().fg(Ansi.Color.DEFAULT)});
    }

    protected static int getPlayerPing(Player player) {
        if (skip) {
            return ReflectionUtil.getReflectionPing(player);
        }
        return compabilityClass.getPlayerPing(player);
    }

    private static int getReflectionPing(Player player) {
        if (disabled) {
            return -1;
        }
        try {
            Object object = ping.get(getHandle.invoke(classCraft.cast(player), new Object[0]));
            if (object instanceof Integer) {
                return (Integer)object;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            PLUGIN.getLogger().log(Level.SEVERE, Ansi.ansi().fg(Ansi.Color.RED) + "Your craftbukkit version isn't compatible with the plugin version. Please contact the developer with the following error" + Ansi.ansi().fg(Ansi.Color.DEFAULT), illegalArgumentException);
        }
        catch (SecurityException securityException) {
            PLUGIN.getLogger().log(Level.SEVERE, Ansi.ansi().fg(Ansi.Color.RED) + "Your vm doesn't allow this plugin to access to the craftbukkit code. This shouldn't happend normaly" + Ansi.ansi().fg(Ansi.Color.DEFAULT), securityException);
        }
        catch (IllegalAccessException illegalAccessException) {
            PLUGIN.getLogger().log(Level.SEVERE, Ansi.ansi().fg(Ansi.Color.RED) + "Your vm doesn't allow this plugin to access to the craftbukkit code. This shouldn't happend normaly" + Ansi.ansi().fg(Ansi.Color.DEFAULT), illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            PLUGIN.getLogger().log(Level.SEVERE, Ansi.ansi().fg(Ansi.Color.RED) + "Please contact the developer with the following error" + Ansi.ansi().fg(Ansi.Color.DEFAULT), invocationTargetException);
        }
        disabled = true;
        return -1;
    }

    public static void initReflections() {
        try {
            classCraft = Class.forName("org.bukkit.craftbukkit." + bukkitVersion + ".entity.CraftPlayer");
            getHandle = classCraft.getDeclaredMethod("getHandle", new Class[0]);
            ping = Class.forName("net.minecraft.server." + bukkitVersion + ".EntityPlayer").getDeclaredField("ping");
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            PLUGIN.getLogger().log(Level.SEVERE, Ansi.ansi().fg(Ansi.Color.RED) + "Your craftbukkit version isn't compatible with the plugin version. Please contact the developer with the following error" + Ansi.ansi().fg(Ansi.Color.DEFAULT), classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            PLUGIN.getLogger().log(Level.SEVERE, Ansi.ansi().fg(Ansi.Color.RED) + "Your craftbukkit version isn't compatible with the plugin version. Please contact the developer with the following error" + Ansi.ansi().fg(Ansi.Color.DEFAULT), noSuchMethodException);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            PLUGIN.getLogger().log(Level.SEVERE, Ansi.ansi().fg(Ansi.Color.RED) + "Your craftbukkit version isn't compatible with the plugin version. Please contact the developer with the following error" + Ansi.ansi().fg(Ansi.Color.DEFAULT), noSuchFieldException);
        }
        catch (SecurityException securityException) {
            PLUGIN.getLogger().log(Level.SEVERE, Ansi.ansi().fg(Ansi.Color.RED) + "Your vm doesn't allow this plugin to access to the craftbukkit code. This shouldn't happend normaly" + Ansi.ansi().fg(Ansi.Color.DEFAULT), securityException);
        }
        disabled = true;
    }

    static {
        String string = Bukkit.getServer().getClass().getPackage().getName();
        bukkitVersion = string.substring(string.lastIndexOf(46) + 1);
        ReflectionUtil.setupClass();
    }
}

