/*
 * Decompiled with CFR 0.152.
 */
package com.github.games647.scoreboardstats.scoreboard;

import com.github.games647.scoreboardstats.ScoreboardStats;
import com.github.games647.scoreboardstats.Settings;
import com.github.games647.scoreboardstats.pvpstats.AppearTask;
import com.github.games647.scoreboardstats.pvpstats.Database;
import com.github.games647.scoreboardstats.pvpstats.DisapperTask;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Score;
import org.bukkit.scoreboard.Scoreboard;
import org.fusesource.jansi.Ansi;

public final class SbManager {
    private SbManager() {
    }

    public static void createScoreboard(Player player) {
        if (!player.hasPermission("scoreboardstats.use") || ScoreboardStats.getInstance().getHidelist().contains(player.getName()) || Settings.isDisabledWorld(player.getWorld().getName())) {
            return;
        }
        if (player.getScoreboard().getObjective(DisplaySlot.SIDEBAR) != null && !player.getScoreboard().getObjective(DisplaySlot.SIDEBAR).getName().equals("ScoreboardStatsT")) {
            return;
        }
        Scoreboard scoreboard = Bukkit.getScoreboardManager().getNewScoreboard();
        Objective objective = scoreboard.registerNewObjective("ScoreboardStats", "dummy");
        objective.setDisplayName(ChatColor.translateAlternateColorCodes((char)'\u00a7', (String)Settings.getTitle()));
        objective.setDisplaySlot(DisplaySlot.SIDEBAR);
        if (player.isOnline()) {
            try {
                player.setScoreboard(scoreboard);
            }
            catch (IllegalStateException illegalStateException) {
                Bukkit.getLogger().log(Level.FINE, "{0}[ScoreboardStats] Cannot set the Scoreboard because the player has disconnected" + Ansi.ansi().fg(Ansi.Color.DEFAULT), Ansi.ansi().fg(Ansi.Color.RED));
            }
            Settings.sendUpdate(player, true);
            if (Settings.isTempScoreboard()) {
                Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)ScoreboardStats.getInstance(), (Runnable)new AppearTask(player), (long)Settings.getTempShow() * 20L);
            }
        }
    }

    public static void createTopListScoreboard(Player player) {
        Scoreboard scoreboard = player.getScoreboard();
        if (!player.hasPermission("scoreboardstats.use") || scoreboard.getObjective(DisplaySlot.SIDEBAR) == null || !scoreboard.getObjective(DisplaySlot.SIDEBAR).getName().startsWith("ScoreboardStats") || ScoreboardStats.getInstance().getHidelist().contains(player.getName())) {
            return;
        }
        if (scoreboard.getObjective("ScoreboardStatsT") != null) {
            scoreboard.getObjective("ScoreboardStatsT").unregister();
        }
        Map<String, Integer> map = Database.getTop();
        String string = Settings.getTempColor();
        Objective objective = scoreboard.registerNewObjective("ScoreboardStatsT", "dummy");
        objective.setDisplayName(ChatColor.translateAlternateColorCodes((char)'\u00a7', (String)Settings.getTempTitle()));
        objective.setDisplaySlot(DisplaySlot.SIDEBAR);
        if (player.isOnline()) {
            try {
                player.setScoreboard(scoreboard);
            }
            catch (IllegalStateException illegalStateException) {
                Bukkit.getLogger().log(Level.FINE, "{0}[ScoreboardStats] Cannot set the Scoreboard because the player has disconnected" + Ansi.ansi().fg(Ansi.Color.DEFAULT), Ansi.ansi().fg(Ansi.Color.RED));
            }
            for (Map.Entry<String, Integer> entry : map.entrySet()) {
                SbManager.sendScore(objective, String.format("%s%s", string, SbManager.checkLength(entry.getKey())), entry.getValue(), false);
            }
            Bukkit.getScheduler().runTaskLater((Plugin)ScoreboardStats.getInstance(), (Runnable)new DisapperTask(player), (long)Settings.getTempDisapper() * 20L);
        }
    }

    public static void sendScore(Objective objective, String string, int n, boolean bl) {
        Score score = objective.getScore(Bukkit.getOfflinePlayer((String)ChatColor.translateAlternateColorCodes((char)'&', (String)string)));
        if (bl && n == 0) {
            score.setScore(-1);
        }
        score.setScore(n);
    }

    private static String checkLength(String string) {
        return string.length() > 14 ? string.substring(0, 14) : string;
    }

    public static void regAll() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)ScoreboardStats.getInstance(), new Runnable(){

            @Override
            public void run() {
                boolean bl = Settings.isPvpStats();
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (!player.isOnline() || !bl) continue;
                    Database.loadAccount(player.getName());
                }
            }
        });
    }

    public static void unregisterAll() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.isOnline()) continue;
            player.getScoreboard().clearSlot(DisplaySlot.SIDEBAR);
        }
    }
}

