/*
 * Decompiled with CFR 0.152.
 */
package com.github.games647.scoreboardstats.scoreboard;

import com.github.games647.scoreboardstats.Settings;
import com.github.games647.scoreboardstats.listener.PluginListener;
import com.github.games647.scoreboardstats.pvpstats.Database;
import com.github.games647.scoreboardstats.pvpstats.PlayerCache;
import com.github.games647.scoreboardstats.scoreboard.ReflectionUtil;
import com.github.games647.scoreboardstats.scoreboard.SimpleClansReplacer;
import com.gmail.nossr50.api.ExperienceAPI;
import com.massivecraft.factions.FPlayer;
import com.massivecraft.factions.FPlayers;
import com.massivecraft.factions.entity.UPlayer;
import java.util.Date;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public final class VariableReplacer {
    private VariableReplacer() {
    }

    public static int getReplacedInt(String string, Player player) {
        int n;
        if (!player.isOnline()) {
            return -1;
        }
        if (Settings.isPvpStats() && (n = VariableReplacer.getPvpValue(string, player.getName())) != -1) {
            return n;
        }
        if (PluginListener.getEconomy() != null && "%econ%".equals(string)) {
            return (int)Math.round(PluginListener.getEconomy().getBalance(player.getName()));
        }
        if (PluginListener.isMcmmo() && (n = VariableReplacer.getMcmmoValue(string, player)) != -1) {
            return n;
        }
        if (PluginListener.getEssentials() != null && "%ticks%".equals(string)) {
            return (int)Math.round(PluginListener.getEssentials().getAverageTPS());
        }
        if (PluginListener.getSimpleclans() != null && (n = SimpleClansReplacer.getSimpleClans1Value(string, player)) != -1) {
            return n;
        }
        if (PluginListener.getSimpleclans2() != null && (n = SimpleClansReplacer.getSimpleClans2Value(string, player)) != -1) {
            return n;
        }
        if (PluginListener.getFactions() != null && (n = VariableReplacer.getFactionsValue(string, player)) != -1) {
            return n;
        }
        if (PluginListener.getHeroes() != null && (n = VariableReplacer.getHeroesValue(string, player)) != -1) {
            return n;
        }
        return VariableReplacer.getBukkitValues(string, player);
    }

    private static int getPvpValue(String string, String string2) {
        PlayerCache playerCache = Database.getCache(string2);
        if (playerCache == null) {
            return -1;
        }
        if ("%kills%".equals(string)) {
            return playerCache.getKills();
        }
        if ("%deaths%".equals(string)) {
            return playerCache.getDeaths();
        }
        if ("%mob%".equals(string)) {
            return playerCache.getMob();
        }
        if ("%kdr%".equals(string)) {
            return Database.getKdr(string2);
        }
        if ("%killstreak%".equals(string)) {
            return playerCache.getStreak();
        }
        if ("%current_streak%".equals(string)) {
            return playerCache.getLastStreak();
        }
        return -1;
    }

    private static int getMcmmoValue(String string, Player player) {
        if ("%powlvl%".equals(string)) {
            return ExperienceAPI.getPowerLevel((Player)player);
        }
        if ("%woodcutting%".equals(string)) {
            return ExperienceAPI.getLevel((Player)player, (String)"WOODCUTTING");
        }
        if ("%acrobatics%".equals(string)) {
            return ExperienceAPI.getLevel((Player)player, (String)"ACROBATICS");
        }
        if ("%archery%".equals(string)) {
            return ExperienceAPI.getLevel((Player)player, (String)"ARCHERY");
        }
        if ("%axes%".equals(string)) {
            return ExperienceAPI.getLevel((Player)player, (String)"AXES");
        }
        if ("%excavation%".equals(string)) {
            return ExperienceAPI.getLevel((Player)player, (String)"EXCAVATION");
        }
        if ("%fishing%".equals(string)) {
            return ExperienceAPI.getLevel((Player)player, (String)"FISHING");
        }
        if ("%herbalism%".equals(string)) {
            return ExperienceAPI.getLevel((Player)player, (String)"HERBALISM");
        }
        if ("%mining%".equals(string)) {
            return ExperienceAPI.getLevel((Player)player, (String)"MINING");
        }
        if ("%repair%".equals(string)) {
            return ExperienceAPI.getLevel((Player)player, (String)"REPAIR");
        }
        if ("%smelting%".equals(string)) {
            return ExperienceAPI.getLevel((Player)player, (String)"SMELTING");
        }
        if ("%swords%".equals(string)) {
            return ExperienceAPI.getLevel((Player)player, (String)"SWORDS");
        }
        if ("%taming%".equals(string)) {
            return ExperienceAPI.getLevel((Player)player, (String)"TAMING");
        }
        if ("%unarmed%".equals(string)) {
            return ExperienceAPI.getLevel((Player)player, (String)"UNARMED");
        }
        return -1;
    }

    private static int getBukkitValues(String string, Player player) {
        if ("%health%".equals(string)) {
            return (int)Math.round(player.getHealth());
        }
        if ("%online%".equals(string)) {
            return VariableReplacer.getOnlinePlayers(player);
        }
        if ("%free_ram%".equals(string)) {
            return (int)(Runtime.getRuntime().freeMemory() / 1024L / 1024L);
        }
        if ("%max_ram%".equals(string)) {
            return (int)Runtime.getRuntime().maxMemory() / 1024 / 1024;
        }
        if ("%used_ram%".equals(string)) {
            return (int)(Runtime.getRuntime().maxMemory() - Runtime.getRuntime().freeMemory()) / 1024 / 1024;
        }
        if ("%used%ram%".equals(string)) {
            return (int)((Runtime.getRuntime().maxMemory() - Runtime.getRuntime().freeMemory()) * 100L / Runtime.getRuntime().maxMemory());
        }
        if ("%date%".equals(string)) {
            return new Date().getDate();
        }
        if ("%lifetime%".equals(string)) {
            return player.getTicksLived() / 20 / 60;
        }
        if ("%exp%".equals(string)) {
            return player.getTotalExperience();
        }
        if ("%no_damage_ticks%".equals(string)) {
            return player.getNoDamageTicks() / 20 / 60;
        }
        if ("%xp_to_level%".equals(string)) {
            return player.getExpToLevel();
        }
        if ("%last_damage%".equals(string)) {
            return (int)player.getLastDamage() / 20 / 60;
        }
        if ("%max_player%".equals(string)) {
            return Bukkit.getMaxPlayers();
        }
        if ("%ping%".equals(string)) {
            return ReflectionUtil.getPlayerPing(player);
        }
        if ("%helmet%".equals(string)) {
            ItemStack itemStack = player.getInventory().getHelmet();
            if (itemStack != null && itemStack.getType().getMaxDurability() != 0) {
                return itemStack.getDurability() * 100 / itemStack.getType().getMaxDurability();
            }
            return -2;
        }
        if ("%boots%".equals(string)) {
            ItemStack itemStack = player.getInventory().getBoots();
            if (itemStack != null && itemStack.getType().getMaxDurability() != 0) {
                return itemStack.getDurability() * 100 / itemStack.getType().getMaxDurability();
            }
            return -2;
        }
        if ("%leggings%".equals(string)) {
            ItemStack itemStack = player.getInventory().getLeggings();
            if (itemStack != null && itemStack.getType().getMaxDurability() != 0) {
                return itemStack.getDurability() * 100 / itemStack.getType().getMaxDurability();
            }
            return -2;
        }
        if ("%chestplate%".equals(string)) {
            ItemStack itemStack = player.getInventory().getChestplate();
            if (itemStack != null && itemStack.getType().getMaxDurability() != 0) {
                return itemStack.getDurability() * 100 / itemStack.getType().getMaxDurability();
            }
            return -2;
        }
        return -1;
    }

    private static int getOnlinePlayers(Player player) {
        if (Settings.isHideVanished()) {
            int n = 0;
            for (Player player2 : Bukkit.getOnlinePlayers()) {
                if (!player.canSee(player2)) continue;
                ++n;
            }
            return n;
        }
        return Bukkit.getOnlinePlayers().length;
    }

    private static int getFactionsValue(String string, Player player) {
        if (PluginListener.getFactions().startsWith("1")) {
            FPlayer fPlayer = (FPlayer)FPlayers.i.get(player);
            if ("%power%".equals(string)) {
                return fPlayer.getPowerRounded();
            }
            if (fPlayer.getFaction() != null) {
                if ("%f_power%".equals(string)) {
                    return fPlayer.getFaction().getPowerRounded();
                }
                if ("%members%".equals(string)) {
                    return fPlayer.getFaction().getFPlayers().size();
                }
                if ("%members_online%".equals(string)) {
                    return fPlayer.getFaction().getOnlinePlayers().size();
                }
            }
        } else {
            UPlayer uPlayer = UPlayer.get((Object)player);
            if ("%power%".equals(string)) {
                return uPlayer.getPowerRounded();
            }
            if (uPlayer.getFaction() != null) {
                if ("%f_power%".equals(string)) {
                    return uPlayer.getFaction().getPowerRounded();
                }
                if ("%members%".equals(string)) {
                    return uPlayer.getFaction().getUPlayers().size();
                }
                if ("%members_online%".equals(string)) {
                    return uPlayer.getFaction().getOnlinePlayers().size();
                }
            }
        }
        return -1;
    }

    private static int getHeroesValue(String string, Player player) {
        if ("%mana%".equals(string)) {
            return PluginListener.getHeroes().getHero(player).getMana();
        }
        if ("%level%".equals(string)) {
            return PluginListener.getHeroes().getHero(player).getLevel();
        }
        if ("%max_mana%".equals(string)) {
            return PluginListener.getHeroes().getHero(player).getMaxMana();
        }
        if ("%mana_regen%".equals(string)) {
            return PluginListener.getHeroes().getHero(player).getManaRegen();
        }
        return -1;
    }
}

