/*
 * Decompiled with CFR 0.152.
 */
package me.KeybordPiano459.ServerHub;

import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class IconMenu
implements Listener {
    private String name;
    private int size;
    private OptionClickEventHandler handler;
    private Plugin plugin;
    private String[] optionNames;
    private ItemStack[] optionIcons;

    public IconMenu(String name, int size, OptionClickEventHandler handler, Plugin plugin) {
        this.name = name;
        this.size = size;
        this.handler = handler;
        this.plugin = plugin;
        this.optionNames = new String[size];
        this.optionIcons = new ItemStack[size];
    }

    public IconMenu setOption(int position, ItemStack icon, String name, List<String> info) {
        this.optionNames[position] = name;
        this.optionIcons[position] = this.setItemNameAndLore(icon, name, info);
        return this;
    }

    public void open(Player player) {
        Inventory inventory = Bukkit.createInventory((InventoryHolder)player, (int)this.size, (String)this.name);
        for (int i = 0; i < this.optionIcons.length; ++i) {
            if (this.optionIcons[i] == null) continue;
            inventory.setItem(i, this.optionIcons[i]);
        }
        player.openInventory(inventory);
    }

    public void destroy() {
        this.handler = null;
        this.plugin = null;
        this.optionNames = null;
        this.optionIcons = null;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    void onInventoryClick(InventoryClickEvent event) {
        if (event.getInventory().getTitle().equals(this.name)) {
            event.setCancelled(true);
            int slot = event.getRawSlot();
            if (slot >= 0 && slot < this.size && this.optionNames[slot] != null) {
                Plugin plg = this.plugin;
                OptionClickEvent e = new OptionClickEvent((Player)event.getWhoClicked(), slot, this.optionNames[slot]);
                this.handler.onOptionClick(e);
                if (e.willClose()) {
                    final Player p = (Player)event.getWhoClicked();
                    Bukkit.getScheduler().scheduleSyncDelayedTask(plg, new Runnable(){

                        @Override
                        public void run() {
                            p.closeInventory();
                        }
                    }, 1L);
                }
                if (e.willDestroy()) {
                    this.destroy();
                }
            }
        }
    }

    private ItemStack setItemNameAndLore(ItemStack item, String name, List<String> lore) {
        ItemMeta im = item.getItemMeta();
        im.setDisplayName(name);
        im.setLore(lore);
        item.setItemMeta(im);
        return item;
    }

    public class OptionClickEvent {
        private Player player;
        private int position;
        private String name;
        private boolean close;
        private boolean destroy;

        public OptionClickEvent(Player player, int position, String name) {
            this.player = player;
            this.position = position;
            this.name = name;
            this.close = true;
            this.destroy = false;
        }

        public Player getPlayer() {
            return this.player;
        }

        public int getPosition() {
            return this.position;
        }

        public String getName() {
            return this.name;
        }

        public boolean willClose() {
            return this.close;
        }

        public boolean willDestroy() {
            return this.destroy;
        }

        public void setWillClose(boolean close) {
            this.close = close;
        }

        public void setWillDestroy(boolean destroy) {
            this.destroy = destroy;
        }
    }

    public static interface OptionClickEventHandler {
        public void onOptionClick(OptionClickEvent var1);
    }
}

