/*
 * Decompiled with CFR 0.152.
 */
package me.KeybordPiano459.ServerHub;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import me.KeybordPiano459.ServerHub.BukkitMetrics;
import me.KeybordPiano459.ServerHub.CommandHub;
import me.KeybordPiano459.ServerHub.Config;
import me.KeybordPiano459.ServerHub.IconMenu;
import me.KeybordPiano459.ServerHub.ItemClick;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ServerHub
extends JavaPlugin {
    private Config config;

    public void onEnable() {
        this.getLogger().info("ServerHub v1.1 has been enabled!");
        this.config = new Config(this);
        this.getCommand("hub").setExecutor((CommandExecutor)new CommandHub(this));
        new File("plugins" + File.separator + "ServerHub").mkdirs();
        this.config.createConfig();
        this.getServer().getPluginManager().registerEvents((Listener)this.getIconMenu(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ItemClick(this), (Plugin)this);
        try {
            BukkitMetrics metrics = new BukkitMetrics((Plugin)this);
            metrics.start();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void onDisable() {
        this.getLogger().info("ServerHub v1.1 has been disabled.");
    }

    public IconMenu getIconMenu() {
        IconMenu menu = new IconMenu(this.getConfig().getString("gui-name"), this.getConfig().getInt("gui-rows") * 9, new IconMenu.OptionClickEventHandler(){

            @Override
            public void onOptionClick(IconMenu.OptionClickEvent event) {
                event.getPlayer().performCommand(ServerHub.this.getConfig().getString("items.slot-" + event.getPosition() + ".command"));
            }
        }, (Plugin)this);
        for (int i = 0; i < this.getConfig().getConfigurationSection("items.").getKeys(false).size(); ++i) {
            ArrayList<String> lorelist = new ArrayList<String>();
            for (int j = 0; j < this.getConfig().getConfigurationSection("items.slot-" + i + ".lore.").getKeys(false).size(); ++j) {
                lorelist.add(this.getConfig().getString("items.slot-" + i + ".lore.line-" + j));
            }
            menu.setOption(i, new ItemStack(this.getConfig().getInt("items.slot-" + i + ".item-id")), this.getConfig().getString("items.slot-" + i + ".name"), lorelist);
        }
        return menu;
    }

    public FileConfiguration getConfig() {
        return this.config.getConfig();
    }

    public void reloadConfig() {
        this.config.reloadConfig();
    }

    public void saveConfig() {
        this.config.saveConfig();
    }
}

