/*
 * Decompiled with CFR 0.152.
 */
package nl.Steffion.BlockHunt;

import java.util.ArrayList;
import java.util.List;
import me.libraryaddict.disguise.DisguiseAPI;
import nl.Steffion.BlockHunt.Arena;
import nl.Steffion.BlockHunt.ConfigC;
import nl.Steffion.BlockHunt.Managers.MessageM;
import nl.Steffion.BlockHunt.Managers.PermissionsM;
import nl.Steffion.BlockHunt.PermissionsC;
import nl.Steffion.BlockHunt.PlayerArenaData;
import nl.Steffion.BlockHunt.ScoreboardHandler;
import nl.Steffion.BlockHunt.Serializables.LocationSerializable;
import nl.Steffion.BlockHunt.SignsHandler;
import nl.Steffion.BlockHunt.W;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.potion.PotionEffect;

public class ArenaHandler {
    public static void loadArenas() {
        W.arenaList.clear();
        for (String arenaName : W.arenas.getFile().getKeys(false)) {
            W.arenaList.add((Arena)W.arenas.getFile().get(arenaName));
        }
        for (Arena arena : W.arenaList) {
            ScoreboardHandler.createScoreboard(arena);
        }
    }

    public static void sendMessage(Arena arena, String message, String ... vars) {
        for (Player player : arena.playersInArena) {
            String pMessage = message.replaceAll("%player%", player.getName());
            player.sendMessage(MessageM.replaceAll(pMessage, vars));
        }
    }

    public static void sendFMessage(Arena arena, ConfigC location, String ... vars) {
        for (Player player : arena.playersInArena) {
            String pMessage = location.config.getFile().get(location.location).toString().replaceAll("%player%", player.getName());
            player.sendMessage(MessageM.replaceAll(pMessage, vars));
        }
    }

    public static void playerJoinArena(Player player, String arenaname) {
        boolean found = false;
        boolean alreadyJoined = false;
        for (Arena arena : W.arenaList) {
            if (arena.playersInArena == null || !arena.playersInArena.contains(player)) continue;
            alreadyJoined = true;
        }
        if (!alreadyJoined) {
            for (Arena arena : W.arenaList) {
                if (!arena.arenaName.equalsIgnoreCase(arenaname)) continue;
                found = true;
                if (arena.disguiseBlocks.isEmpty()) {
                    MessageM.sendFMessage(player, ConfigC.error_joinNoBlocksSet, new String[0]);
                    continue;
                }
                boolean inventoryempty = true;
                for (ItemStack invitem : player.getInventory()) {
                    if (invitem == null || invitem.getType() == Material.AIR) continue;
                    inventoryempty = false;
                }
                ItemStack[] itemStackArray = player.getInventory().getArmorContents();
                int n = itemStackArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ItemStack invitem;
                    invitem = itemStackArray[n2];
                    if (invitem.getType() != Material.AIR) {
                        inventoryempty = false;
                    }
                    ++n2;
                }
                if (((Boolean)W.config.get(ConfigC.requireInventoryClearOnJoin)).booleanValue() && !inventoryempty) {
                    MessageM.sendFMessage(player, ConfigC.error_joinInventoryNotEmpty, new String[0]);
                    return;
                }
                LocationSerializable zero = new LocationSerializable(Bukkit.getWorld((String)player.getWorld().getName().toString()), 0.0, 0.0, 0.0, 0.0f, 0.0f);
                if (arena.lobbyWarp != null && arena.hidersWarp != null && arena.seekersWarp != null && arena.spawnWarp != null) {
                    if (!(arena.lobbyWarp.equals((Object)zero) || arena.hidersWarp.equals((Object)zero) || arena.seekersWarp.equals((Object)zero) || arena.spawnWarp.equals((Object)zero))) {
                        if (arena.gameState == Arena.ArenaState.WAITING || arena.gameState == Arena.ArenaState.STARTING) {
                            ArrayList<String> lores2;
                            List lores;
                            if (arena.playersInArena.size() >= arena.maxPlayers && !PermissionsM.hasPerm(player, PermissionsC.Permissions.joinfull, false)) {
                                MessageM.sendFMessage(player, ConfigC.error_joinFull, new String[0]);
                                return;
                            }
                            arena.playersInArena.add(player);
                            PlayerArenaData pad = new PlayerArenaData(player.getLocation(), player.getGameMode(), player.getInventory().getContents(), player.getInventory().getArmorContents(), Float.valueOf(player.getExp()), player.getLevel(), player.getHealth(), player.getFoodLevel(), player.getActivePotionEffects(), player.getAllowFlight());
                            W.pData.put(player, pad);
                            player.teleport((Location)arena.lobbyWarp);
                            player.setGameMode(GameMode.SURVIVAL);
                            for (PotionEffect pe : player.getActivePotionEffects()) {
                                player.removePotionEffect(pe.getType());
                            }
                            player.setFoodLevel(20);
                            player.setHealth(20.0);
                            player.setLevel(arena.timer);
                            player.setExp(0.0f);
                            player.getInventory().clear();
                            player.getInventory().setHelmet(new ItemStack(Material.AIR));
                            player.getInventory().setChestplate(new ItemStack(Material.AIR));
                            player.getInventory().setLeggings(new ItemStack(Material.AIR));
                            player.getInventory().setBoots(new ItemStack(Material.AIR));
                            player.setFlying(false);
                            player.setAllowFlight(false);
                            if (((Boolean)W.config.get(ConfigC.shop_blockChooserv1Enabled)).booleanValue() && (W.shop.getFile().get(String.valueOf(player.getName()) + ".blockchooser") != null || PermissionsM.hasPerm(player, PermissionsC.Permissions.shopblockchooser, false))) {
                                ItemStack shopBlockChooser = new ItemStack(Material.getMaterial((String)((String)W.config.get(ConfigC.shop_blockChooserv1IDname))), 1);
                                ItemMeta shopBlockChooser_IM = shopBlockChooser.getItemMeta();
                                shopBlockChooser_IM.setDisplayName(MessageM.replaceAll((String)W.config.get(ConfigC.shop_blockChooserv1Name), new String[0]));
                                lores = W.config.getFile().getStringList(ConfigC.shop_blockChooserv1Description.location);
                                lores2 = new ArrayList<String>();
                                for (String lore : lores) {
                                    lores2.add(MessageM.replaceAll(lore, new String[0]));
                                }
                                shopBlockChooser_IM.setLore(lores2);
                                shopBlockChooser.setItemMeta(shopBlockChooser_IM);
                                player.getInventory().addItem(new ItemStack[]{shopBlockChooser});
                            }
                            if (((Boolean)W.config.get(ConfigC.shop_BlockHuntPassv2Enabled)).booleanValue() && W.shop.getFile().getInt(String.valueOf(player.getName()) + ".blockhuntpass") != 0) {
                                ItemStack shopBlockHuntPass = new ItemStack(Material.getMaterial((String)((String)W.config.get(ConfigC.shop_BlockHuntPassv2IDName))), 1);
                                ItemMeta shopBlockHuntPass_IM = shopBlockHuntPass.getItemMeta();
                                shopBlockHuntPass_IM.setDisplayName(MessageM.replaceAll((String)W.config.get(ConfigC.shop_BlockHuntPassv2Name), new String[0]));
                                lores = W.config.getFile().getStringList(ConfigC.shop_BlockHuntPassv2Description.location);
                                lores2 = new ArrayList();
                                for (String lore : lores) {
                                    lores2.add(MessageM.replaceAll(lore, new String[0]));
                                }
                                shopBlockHuntPass_IM.setLore(lores2);
                                shopBlockHuntPass.setItemMeta(shopBlockHuntPass_IM);
                                shopBlockHuntPass.setAmount(W.shop.getFile().getInt(String.valueOf(player.getName()) + ".blockhuntpass"));
                                player.getInventory().addItem(new ItemStack[]{shopBlockHuntPass});
                            }
                            player.updateInventory();
                            DisguiseAPI.undisguiseToAll((Entity)player);
                            ArenaHandler.sendFMessage(arena, ConfigC.normal_joinJoinedArena, "playername-" + player.getName(), "1-" + arena.playersInArena.size(), "2-" + arena.maxPlayers);
                            if (arena.playersInArena.size() >= arena.minPlayers) continue;
                            ArenaHandler.sendFMessage(arena, ConfigC.warning_lobbyNeedAtleast, "1-" + arena.minPlayers);
                            continue;
                        }
                        MessageM.sendFMessage(player, ConfigC.error_joinArenaIngame, new String[0]);
                        continue;
                    }
                    MessageM.sendFMessage(player, ConfigC.error_joinWarpsNotSet, new String[0]);
                    continue;
                }
                MessageM.sendFMessage(player, ConfigC.error_joinWarpsNotSet, new String[0]);
            }
        } else {
            MessageM.sendFMessage(player, ConfigC.error_joinAlreadyJoined, new String[0]);
            return;
        }
        if (!found) {
            MessageM.sendFMessage(player, ConfigC.error_noArena, "name-" + arenaname);
        }
        SignsHandler.updateSigns();
    }

    public static void playerLeaveArena(Player player, boolean message, boolean cleanup) {
        Arena arena = null;
        for (Arena arena2 : W.arenaList) {
            if (arena2.playersInArena == null || !arena2.playersInArena.contains(player)) continue;
            arena = arena2;
        }
        if (arena != null) {
            Player pl;
            int n;
            int n2;
            Player[] playerArray;
            if (cleanup) {
                arena.playersInArena.remove(player);
                if (arena.seekers.contains(player)) {
                    arena.seekers.remove(player);
                }
                if (arena.playersInArena.size() < arena.minPlayers && arena.gameState.equals((Object)Arena.ArenaState.STARTING)) {
                    arena.gameState = Arena.ArenaState.WAITING;
                    arena.timer = 0;
                    ArenaHandler.sendFMessage(arena, ConfigC.warning_lobbyNeedAtleast, "1-" + arena.minPlayers);
                }
                if (arena.playersInArena.size() <= 1 && arena.gameState == Arena.ArenaState.INGAME) {
                    if (arena.seekers.size() >= arena.playersInArena.size()) {
                        ArenaHandler.seekersWin(arena);
                    } else {
                        ArenaHandler.hidersWin(arena);
                    }
                }
                if (arena.seekers.size() >= arena.playersInArena.size()) {
                    ArenaHandler.seekersWin(arena);
                }
                if (arena.seekers.size() <= 0 && arena.gameState == Arena.ArenaState.INGAME) {
                    Player seeker = arena.playersInArena.get(W.random.nextInt(arena.playersInArena.size()));
                    ArenaHandler.sendFMessage(arena, ConfigC.warning_ingameNEWSeekerChoosen, "seeker-" + seeker.getName());
                    ArenaHandler.sendFMessage(arena, ConfigC.normal_ingameSeekerChoosen, "seeker-" + seeker.getName());
                    DisguiseAPI.undisguiseToAll((Entity)seeker);
                    playerArray = Bukkit.getOnlinePlayers();
                    n2 = playerArray.length;
                    n = 0;
                    while (n < n2) {
                        pl = playerArray[n];
                        pl.showPlayer(seeker);
                        ++n;
                    }
                    seeker.getInventory().clear();
                    arena.seekers.add(seeker);
                    seeker.teleport((Location)arena.seekersWarp);
                    W.seekertime.put(seeker, arena.waitingTimeSeeker);
                }
            }
            PlayerArenaData pad = new PlayerArenaData(null, null, null, null, null, null, null, null, null, false);
            if (W.pData.get(player) != null) {
                pad = W.pData.get(player);
            }
            player.getInventory().clear();
            player.getInventory().setContents(pad.pInventory);
            player.getInventory().setArmorContents(pad.pArmor);
            player.updateInventory();
            player.setExp(pad.pEXP.floatValue());
            player.setLevel(pad.pEXPL.intValue());
            player.setHealth(pad.pHealth.doubleValue());
            player.setFoodLevel(pad.pFood.intValue());
            player.addPotionEffects(pad.pPotionEffects);
            player.teleport((Location)arena.spawnWarp);
            player.setGameMode(pad.pGameMode);
            player.setAllowFlight(pad.pFlying);
            if (player.getAllowFlight()) {
                player.setFlying(true);
            }
            W.pData.remove(player);
            playerArray = Bukkit.getOnlinePlayers();
            n2 = playerArray.length;
            n = 0;
            while (n < n2) {
                pl = playerArray[n];
                pl.showPlayer(player);
                if (W.hiddenLoc.get(player) != null && W.hiddenLocWater.get(player) != null) {
                    Block pBlock = W.hiddenLoc.get(player).getBlock();
                    if (W.hiddenLocWater.get(player).booleanValue()) {
                        pl.sendBlockChange(pBlock.getLocation(), Material.STATIONARY_WATER, (byte)0);
                    } else {
                        pl.sendBlockChange(pBlock.getLocation(), Material.AIR, (byte)0);
                    }
                }
                DisguiseAPI.undisguiseToAll((Entity)player);
                ++n;
            }
            ScoreboardHandler.removeScoreboard(player);
            MessageM.sendFMessage(player, ConfigC.normal_leaveYouLeft, new String[0]);
            if (message) {
                ArenaHandler.sendFMessage(arena, ConfigC.normal_leaveLeftArena, "playername-" + player.getName(), "1-" + arena.playersInArena.size(), "2-" + arena.maxPlayers);
            }
        } else {
            if (message) {
                MessageM.sendFMessage(player, ConfigC.error_leaveNotInArena, new String[0]);
            }
            return;
        }
        SignsHandler.updateSigns();
    }

    public static void seekersWin(Arena arena) {
        ArenaHandler.sendFMessage(arena, ConfigC.normal_winSeekers, new String[0]);
        for (Player player : arena.playersInArena) {
            if (arena.seekersWinCommands == null) continue;
            for (String command : arena.seekersWinCommands) {
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command.replaceAll("%player%", player.getName()));
            }
            if (W.shop.getFile().get(String.valueOf(player.getName()) + ".tokens") == null) {
                W.shop.getFile().set(String.valueOf(player.getName()) + ".tokens", (Object)0);
                W.shop.save();
            }
            int playerTokens = W.shop.getFile().getInt(String.valueOf(player.getName()) + ".tokens");
            W.shop.getFile().set(String.valueOf(player.getName()) + ".tokens", (Object)(playerTokens + arena.seekersTokenWin));
            W.shop.save();
            MessageM.sendFMessage(player, ConfigC.normal_addedToken, "amount-" + arena.seekersTokenWin);
        }
        arena.seekers.clear();
        for (Player player : arena.playersInArena) {
            ArenaHandler.playerLeaveArena(player, false, false);
            player.playSound(player.getLocation(), Sound.LEVEL_UP, 1.0f, 1.0f);
        }
        arena.gameState = Arena.ArenaState.WAITING;
        arena.timer = 0;
        arena.playersInArena.clear();
    }

    public static void hidersWin(Arena arena) {
        ArenaHandler.sendFMessage(arena, ConfigC.normal_winHiders, new String[0]);
        for (Player player : arena.playersInArena) {
            if (arena.seekers.contains(player) || arena.hidersWinCommands == null) continue;
            for (String command : arena.hidersWinCommands) {
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command.replaceAll("%player%", player.getName()));
            }
            if (W.shop.getFile().get(String.valueOf(player.getName()) + ".tokens") == null) {
                W.shop.getFile().set(String.valueOf(player.getName()) + ".tokens", (Object)0);
                W.shop.save();
            }
            int playerTokens = W.shop.getFile().getInt(String.valueOf(player.getName()) + ".tokens");
            W.shop.getFile().set(String.valueOf(player.getName()) + ".tokens", (Object)(playerTokens + arena.hidersTokenWin));
            W.shop.save();
            MessageM.sendFMessage(player, ConfigC.normal_addedToken, "amount-" + arena.hidersTokenWin);
        }
        arena.seekers.clear();
        for (Player player : arena.playersInArena) {
            ArenaHandler.playerLeaveArena(player, false, false);
            player.playSound(player.getLocation(), Sound.LEVEL_UP, 1.0f, 1.0f);
        }
        arena.gameState = Arena.ArenaState.WAITING;
        arena.timer = 0;
        arena.playersInArena.clear();
    }

    public static void stopArena(Arena arena) {
        ArenaHandler.sendFMessage(arena, ConfigC.warning_arenaStopped, new String[0]);
        arena.seekers.clear();
        for (Player player : arena.playersInArena) {
            ArenaHandler.playerLeaveArena(player, false, false);
            player.playSound(player.getLocation(), Sound.LEVEL_UP, 1.0f, 1.0f);
        }
        arena.gameState = Arena.ArenaState.WAITING;
        arena.timer = 0;
        arena.playersInArena.clear();
    }
}

