/*
 * Decompiled with CFR 0.152.
 */
package nl.Steffion.BlockHunt.Serializables;

import java.util.HashMap;
import java.util.Map;
import nl.Steffion.BlockHunt.Managers.MessageM;
import nl.Steffion.BlockHunt.Serializables.M;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.SerializableAs;

@SerializableAs(value="BlockHuntLocation")
public class LocationSerializable
extends Location
implements ConfigurationSerializable {
    public LocationSerializable(World world, double x, double y, double z, float yaw, float pitch) {
        super(world, x, y, z, yaw, pitch);
    }

    public LocationSerializable(Location loc) {
        super(loc.getWorld(), loc.getX(), loc.getY(), loc.getZ(), loc.getYaw(), loc.getPitch());
    }

    public boolean equals(Object o) {
        if (o instanceof LocationSerializable || o instanceof Location) {
            Location loc = (Location)o;
            return loc.getWorld().getName().equals(this.getWorld().getName()) && loc.getX() == this.getX() && loc.getY() == this.getY() && loc.getZ() == this.getZ() && loc.getYaw() == this.getYaw() && loc.getPitch() == this.getPitch();
        }
        return false;
    }

    public Map<String, Object> serialize() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("w", this.getWorld().getName());
        map.put("x", this.getX());
        map.put("y", this.getY());
        map.put("z", this.getZ());
        if ((double)this.getYaw() != 0.0) {
            map.put("a", Float.valueOf(this.getYaw()));
        }
        if ((double)this.getPitch() != 0.0) {
            map.put("p", Float.valueOf(this.getPitch()));
        }
        return map;
    }

    public static LocationSerializable deserialize(Map<String, Object> map) {
        World w = Bukkit.getWorld((String)((String)M.g(map, "w", "")));
        if (w == null) {
            MessageM.sendMessage(null, "%EError deserializing LocationSerializable - world not found! (%A%w%%E)", "w-" + w);
            return null;
        }
        return new LocationSerializable(w, (Double)M.g(map, "x", 0.0), (Double)M.g(map, "y", 0.0), (Double)M.g(map, "z", 0.0), ((Double)M.g(map, "a", 0.0)).floatValue(), ((Double)M.g(map, "p", 0.0)).floatValue());
    }
}

